; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


[Command]
name = "cpu1"
command = x, x
time = 0

[Command]
name = "cpu2"
command = y, y
time = 0

[Command]
name = "cpu3"
command = z, z
time = 0

[Command]
name = "cpu4"
command = a, a
time = 0

[Command]
name = "cpu5"
command = b, a
time = 0

[Command]
name = "cpu6"
command = c, b
time = 0

[Command]
name = "cpu7"
command = c, c
time = 0

[Command]
name = "cpu8"
command = y, x
time = 0

[Command]
name = "cpu9"
command = x, y
time = 0

[Command]
name = "cpu10"
command = ~D, DF, F, x
time = 0

;-| Super Motions |--------------------------------------------------------

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, D, DF, F, x
time = 20

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, D, DF, F, y
time = 20

[Command]
name = "SmashKFUpper"
command = ~D, DB, B, D, DB, B, x;~F, D, DF, F, D, DF, x
time = 20

[Command]
name = "SmashKFUpper"   ;Same name as above
command = ~D, DB, B, D, DB, B, y;~F, D, DF, F, D, DF, y
time = 20

;-| Special Motions |------------------------------------------------------

[Command]
name = "c_throw"
command = ~F, D, B, U, x
time = 40

[Command]
name = "c_throw"
command = ~D, B, U, F, x
time = 40

[Command]
name = "c_throw"
command = ~B, U, F, D, x
time = 40

[Command]
name = "c_throw"
command = ~U, F, D, B, x
time = 40

[Command]
name = "c_throw"
command = ~F, U, B, D, x
time = 40

[Command]
name = "c_throw"
command = ~D, F, U, B, x
time = 40

[Command]
name = "c_throw"
command = ~B, D, F, U, x
time = 40

[Command]
name = "c_throw"
command = ~U, B, D, F, x
time = 40

[Command]
name = "c_throw"
command = ~F, D, B, U, y
time = 40

[Command]
name = "c_throw"
command = ~D, B, U, F, y
time = 40

[Command]
name = "c_throw"
command = ~B, U, F, D, y
time = 40

[Command]
name = "c_throw"
command = ~U, F, D, B, y
time = 40

[Command]
name = "c_throw"
command = ~F, U, B, D, y
time = 40

[Command]
name = "c_throw"
command = ~D, F, U, B, y
time = 40

[Command]
name = "c_throw"
command = ~B, D, F, U, y
time = 40

[Command]
name = "c_throw"
command = ~U, B, D, F, y
time = 40

[Command]
name = "upper"
command = ~F, D, /DF

[Command]
name = "upper_x"
command = ~F, D, DF, x

[Command]
name = "upper_y"
command = ~F, D, DF, y

[Command]
name = "upper_z"
command = ~F, D, DF, z

[Command]
name = "upper_s"
command = ~F, D, DF, s

[Command]
name = "upper_xy"
command = ~F, D, DF, x+y

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_z"
command = ~D, DF, F, z

[Command]
name = "QCF_a"
command = ~D, DF, F, a

[Command]
name = "QCF_b"
command = ~D, DF, F, b

[Command]
name = "QCF_c"
command = ~D, DF, F, c

[Command]
name = "QCF_s"
command = ~D, DF, F, s

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

[Command]
name = "QCF_yz"
command = ~D, DF, F, y+z

[Command]
name = "QCF_xz"
command = ~D, DF, F, x+z

[Command]
name = "QCB_x"
command = ~D, DB, B, x

[Command]
name = "QCB_y"
command = ~D, DB, B, y

[Command]
name = "QCB_z"
command = ~D, DB, B, z

[Command]
name = "QCB_a"
command = ~D, DB, B, a

[Command]
name = "QCB_b"
command = ~D, DB, B, b

[Command]
name = "QCB_c"
command = ~D, DB, B, c

[Command]
name = "QCB-x"
command = ~D, DB, B, ~x

[Command]
name = "QCB-y"
command = ~D, DB, B, ~y

[Command]
name = "QCB-z"
command = ~D, DB, B, ~z

[Command]
name = "QCB_s"
command = ~D, DB, B, s

[Command]
name = "QCB_xy"
command = ~D, DB, B, x+y

[Command]
name = "QCB_yz"
command = ~D, DB, B, y+z

[Command]
name = "QCB_xz"
command = ~D, DB, B, x+z

[Command]
name = "QCB_xyz"
command = ~D, DB, B, x+y+z

[Command]
name = "rd_x"
command = ~60$B, F, x

[Command]
name = "rd_y"
command = ~60$B, F, y

[Command]
name = "rd_z"
command = ~60$B, F, z

[Command]
name = "rd_x2"
command = B, F, x

[Command]
name = "rd_y2"
command = B, F, y

[Command]
name = "rd_z2"
command = B, F, z

[Command]
name = "ss_x"
command = ~60$D, U, x

[Command]
name = "ss_y"
command = ~60$D, U, y

[Command]
name = "ss_z"
command = ~60$D, U, z

[Command]
name = "ss_x2"
command = ~D, U, x

[Command]
name = "ss_y2"
command = ~D, U, y

[Command]
name = "ss_z2"
command = ~D, U, z

[Command]
name = "FF_ab"
command = F, F, a+b

[Command]
name = "FF_a"
command = F, F, a

[Command]
name = "ax"
command = a+x
time = 1

[Command]
name = "ay"
command = a+y
time = 1

[Command]
name = "az"
command = a+z
time = 1

[Command]
name = "bx"
command = b+x
time = 1

[Command]
name = "by"
command = b+y
time = 1

[Command]
name = "bz"
command = b+z
time = 1

[Command]
name = "xxx"
command = x,x,x
time = 17

[Command]
name = "yyy"
command = y,y,y
time = 17

[Command]
name = "zzz"
command = z,z,z
time = 17

[Command]
name = "xx"
command = x,x
time = 17

[Command]
name = "yy"
command = y,y
time = 17

[Command]
name = "zz"
command = z,z
time = 17

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
name = "bc"
command = b+c
time = 1

[Command]
name = "xy"
command = x+y
time = 1

[Command]
name = "yz"
command = y+z
time = 1

[Command]
name = "xyz"
command = x+y+z
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "fwd_a"
command = /F,a
time = 1

[Command]
name = "fwd_b"
command = /F,b
time = 1

;[Command]
;name = "fwd_c"
;command = /F,c
;time = 1

[Command]
name = "fwd_x"
command = /F,x
time = 1

[Command]
name = "fwd_y"
command = /F,y
time = 1

[Command]
name = "fwd_z"
command = /F,z
time = 1

[Command]
name = "downfwd_a"
command = /DF,a
time = 1

[Command]
name = "upfwd_a"
command = /UF,a
time = 1

[Command]
name = "downfwd_b"
command = /DF,b
time = 1

[Command]
name = "sla"
command = /DF,y
time = 1

[Command]
name = "downfwd_z"
command = /DF,z
time = 1

[Command]
name = "downfwd_x"
command = /DF,x
time = 2

[Command]
name = "downb_x"
command = /DB,x
time = 1

[Command]
name = "downb_z"
command = /DB,z
time = 2

[Command]
name = "back_a"
command = /B,a
time = 1

[Command]
name = "back_b"
command = /B,b
time = 1

[Command]
name = "back_c"
command = /B,c
time = 1

[Command]
name = "back_z"
command = /B,z
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "fwd_ab"
command = /F, a+b
time = 1

;[Command]
;name = "back_ab"
;command = /B, a+b
;time = 1

[Command]
name = "DU"
command = $D, $U
time = 15

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdf";Required (do not remove)
command = /F
time = 1

[Command]
name = "holddf";Required (do not remove)
command = /DF
time = 20

[Command]
name = "d"
command = /D
time = 1

[Command]
name = "db"
command = /DB
time = 1

[Command]
name = "ub"
command = /UB
time = 1

[Command]
name = "u"
command = /U
time = 1

[Command]
name = "uf"
command = /UF
time = 1

[Command]
name = "df";Required (do not remove)
command = /DF
time = 1

[Command]
name = "holdba";Required (do not remove)
command = /B
time = 1

[Command]
name = "holdx";Required (do not remove)
command = /x
time = 1

[Command]
name = "holdy"
command = /y
time = 1

[Command]
name = "holdz"
command = /z
time = 1

[Command]
name = "holda"
command = /a
time = 1

[Command]
name = "holdb"
command = /b
time = 1

[Command]
name = "holdc"
command = /c
time = 1

[Command]
name = "holds"
command = /s
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
[Statedef -1]

;========X[p[A^bN==============
;X[o[A^bN̂P (uses one super bar)
[State -1, ֓Q]
type = ChangeState
value = 3050
triggerall = command = "QCB-z" || command = "QCB-x" || command = "QCB-y" || command = "QCB_xyz"
triggerall = power >= 1000 && numhelper(1) = 0 && numhelper(3) = 0
triggerall = statetype != A && numhelper(500) = 0 && numhelper(100) = 0
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3100)
trigger2 = movecontact

[State -1, ֓Q]
type = ChangeState
value = 3050
triggerall = command = "QCB_xy" || command = "QCB_yz" || command = "QCB_xz"
triggerall = power >= 1000 && numhelper(1) = 0 && numhelper(3) = 0
triggerall = statetype != A && numhelper(500) = 0 && numhelper(100) = 0
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3100)
trigger2 = movecontact

;---------------------------------------------------------------------------
;X[p[A^bN̂Q (uses one super bar)
[State -1, SC]
type = ChangeState
value = 3000
triggerall = command = "TripleKFPalm" || command = "QCF_xy"
triggerall = power >= 1000 && numhelper(100) = 0
triggerall = numhelper(500) = 0 && numhelper(1) = 0
trigger1 = numhelper(100) = 0 && statetype != A && ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3050)
trigger2 = movecontact

[State -1, SC]
type = ChangeState
value = 3020
triggerall = command = "TripleKFPalm" || command = "QCF_xy"
triggerall = power >= 1000 && numhelper(100) = 1 && var(14) = 0
triggerall = numhelper(500) = 0 && numhelper(1) = 0
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3050)
trigger2 = movecontact

[State -1, SC]
type = ChangeState
value = 2518
triggerall = command = "TripleKFPalm" || command = "QCF_xy"
triggerall = power >= 1000 && numhelper(100) = 1 && var(14) = 5
triggerall = numhelper(500) = 0 && numhelper(1) = 0
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3050)
trigger2 = movecontact
;---------------------------------------------------------------------------
;X[p[A^bN̂R (uses one super bar)
[State -1, S㇗]
type = ChangeState
value = 3015
triggerall = command = "QCF_yz"
triggerall = power >= 1000
triggerall = numhelper(100) = 1 && numhelper(500) = 0 && numhelper(1) = 0 && var(14) = 0
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3050)
trigger2 = movecontact

[State -1, S㇗]
type = ChangeState
value = 2521
triggerall = command = "QCF_yz"
triggerall = power >= 1000
triggerall = numhelper(100) = 1 && numhelper(500) = 0 && numhelper(1) = 0 && var(14) = 5
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3050)
trigger2 = movecontact

;---------------------------------------------------------------------------
;X[p[A^bN̂S (uses one super bar)
[State -1, ҏ\g]
type = ChangeState
value = 1749
triggerall = command = "TripleKFPalm" || command = "QCF_xy"
triggerall = power >= 1000
triggerall = statetype != A && numhelper(500) = 0 && numhelper(100) = 1 && var(14) = 1
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = (stateno != [700,3050)) && stateno != 244
trigger2 = movecontact

[State -1, ҏ\g]
type = ChangeState
value = 2070
triggerall = command = "TripleKFPalm" || command = "QCF_xy"
triggerall = power >= 1000
triggerall = statetype != A && numhelper(500) = 0 && numhelper(100) = 1 && var(14) = 6
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = (stateno != [700,3050)) && stateno != 244
trigger2 = movecontact
;---------------------------------------------------------------------------
;X[p[A^bN̂T (uses one super bar)
[State -1, Rj[Ƃ]
type = ChangeState
value = 3600
triggerall = command = "QCB_xy" || command = "QCB_yz" || command = "QCB_xz"
triggerall = power >= 1000
triggerall = statetype != A && numhelper(500) = 0 && numhelper(100) = 1 && var(14) = 1
trigger1 = ctrl

;X[p[A^bN̂T (uses one super bar)
[State -1, Rj[Ƃ]
type = ChangeState
value = 2075+(command = "QCB_xz" && StateType != A)+6*(StateType = A)
triggerall = command = "QCB_xy" || command = "QCB_yz" || command = "QCB_xz"
triggerall = power >= 1000
triggerall = numhelper(500) = 0 && numhelper(100) = 1 && var(14) = 6
trigger1 = ctrl
;---------------------------------------------------------------------------
;X[p[A^bN̂U (uses one super bar)
[State -1, ֓Q]
type = ChangeState
value = 3100-581*(var(14) = 5)
triggerall = command = "QCB_xy" || command = "QCB_yz" || command = "QCB_xz"
triggerall = numhelper(100) = 1 && power >= 1000 && statetype != A
triggerall = numhelper(500) = 0 && numhelper(1) = 0 && var(14) != 1
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3050)
trigger2 = movecontact

[State -1, ߂Ɣ]
type = ChangeState
value = 3300-780*(var(14) = 5)
triggerall = var(25) = 4
triggerall = power >= 1000 && statetype != A && numhelper(100) = 1 && (var(14) = 0 || var(14) = 5)
trigger1 = ctrl
trigger2 = (stateno = [200,243]) || (stateno = [400,499]) || (stateno = [2501,2510])
;trigger2 = movecontact

;==========XyVA^bN====================
[State -1, CV]
type = ChangeState
value = 1726
triggerall = command = "upper_x" || command = "upper_y" || command = "upper_z"
triggerall = statetype != A && numhelper(100) = 1 && var(14) = 1
trigger1 = ctrl
trigger2 = (stateno = [200,243]) || (stateno = [400,499])
trigger2 = movecontact && stateno != 229 && stateno != 244

;[State -1, nl]
;type = ChangeState
;value = 3320
;triggerall = command = "upper_x" || command = "upper_y" || command = "upper_z"
;triggerall = statetype != A && numhelper(100) = 0 && var(14) = 0
;trigger1 = ctrl
;trigger2 = (stateno = [200,243]) || (stateno = [400,499])
;trigger2 = movecontact

[State -1, SC]
type = ChangeState
value = 1000 + 600*(numhelper(100) = 1)
triggerall = command = "QCF_x" || command = "QCF_y" || command = "QCF_z" 
triggerall = statetype != A && numhelper(1) = 0 && numhelper(500) = 0 && var(14) = 0
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = (stateno = [150,153]) && numhelper(100) = 0

[State -1, ]
type = ChangeState
value = ifelse(command = "QCF_x",1710,ifelse(command = "QCF_y",1713,1714))
triggerall = command = "QCF_x" || command = "QCF_y" || command = "QCF_z" 
triggerall = statetype != A && numhelper(1) = 0 && numhelper(500) = 0 && numhelper(100) = 1 && var(14) = 1
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact
trigger3 = (stateno = [150,153]) && numhelper(100) = 0

[State -1, ]
type = ChangeState
value = ifelse(command = "QCF_x",2056,ifelse(command = "QCF_y",2059,2060))
triggerall = command = "QCF_x" || command = "QCF_y" || command = "QCF_z" 
triggerall = statetype != A && numhelper(1) = 0 && numhelper(500) = 0 && numhelper(100) = 1 && var(14) = 6
trigger1 = ctrl
trigger2 = (stateno = [2530,2543]) && movecontact

[State -1, SC]
type = ChangeState
value = 1605
triggerall = command = "QCF_x" || command = "QCF_y" || command = "QCF_z" 
triggerall = statetype = A && numhelper(1) = 0 && numhelper(100) = 1 && numhelper(500) = 0 && var(14) = 0
trigger1 = ctrl

[State -1, SC]
type = ChangeState
value = 2515
triggerall = command = "QCF_x" || command = "QCF_y" || command = "QCF_z" 
triggerall = statetype != A && numhelper(1) = 0 && numhelper(100) = 1 && numhelper(500) = 0 && var(14) = 5
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact

[State -1, SC]
type = ChangeState
value = 2516
triggerall = command = "QCF_x" || command = "QCF_y" || command = "QCF_z" 
triggerall = statetype = A && numhelper(1) = 0 && numhelper(100) = 1 && numhelper(500) = 0 && var(14) = 5
trigger1 = ctrl
;---------------------------------------------------------------------------
[State -1, sӑłA^bN]
type = ChangeState
value = 1430
triggerall = command = "QCF_a" || command = "QCF_b"
triggerall = numhelper(500) = 0 && numhelper(1) = 0 && statetype != A && numhelper(100) = 0
trigger1 = ctrl

[State -1, sӑłA^bN]
type = ChangeState
value = 1420
triggerall = command = "holdfwd" && command = "xy"
triggerall = numhelper(500) = 0 && numhelper(1) = 0 && statetype != A && numhelper(100) = 1 && var(14) = 0
trigger1 = ctrl

[State -1, sӑłA^bN]
type = ChangeState
value = 1421
triggerall = command = "holdfwd" && command = "xy"
triggerall = numhelper(500) = 0 && numhelper(1) = 0 && statetype != A && numhelper(100) = 1 && var(14) = 1
trigger1 = ctrl
;---------------------------------------------------------------------------

[State -1, Guard Cancel]
type = ChangeState
value = 900
triggerall = command = "QCF_x" || command = "QCF_y" || command = "QCF_z" 
trigger1 = statetype != A && numhelper(1) = 0 && numhelper(500) = 0 && var(14) = 0 && numhelper(100) = 1
trigger1 = stateno = [150,153]

[State -1, S]
type = ChangeState
value = 1100
triggerall = command = "QCB_x" || command = "QCB_y"|| command = "QCB_z"
triggerall = statetype != A && numhelper(100) = 0 && numhelper(500) = 0 && numhelper(1) = 0 && numhelper(2) = 0
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact

[State -1, S]
type = ChangeState
value = 1200
triggerall = (command = "QCB_x" && numhelper(300) = 0) || (command = "QCB_y" && numhelper(301) = 0) || (command = "QCB_z" && numhelper(302) = 0)
triggerall = statetype != A && numhelper(100) = 1 && numhelper(500) = 0 && var(14) = 0
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact

[State -1, S]
type = ChangeState
value = 1210
triggerall = (command = "QCB_x" && numhelper(300) = 0) || (command = "QCB_y" && numhelper(301) = 0) || (command = "QCB_z" && numhelper(302) = 0)
triggerall = statetype = A && numhelper(100) = 1 && numhelper(500) = 0 && var(14) = 0
trigger1 = ctrl

[State -1, S]
type = ChangeState
value = 2517
triggerall = (command = "QCB_x" && numhelper(300) = 0) || (command = "QCB_y" && numhelper(301) = 0) || (command = "QCB_z" && numhelper(302) = 0)
triggerall = numhelper(100) = 1 && numhelper(500) = 0 && var(14) = 5
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = statetype != A && movecontact

[State -1, ]
type = ChangeState
value = ifelse(command = "QCB_x",1720,ifelse(command = "QCB_y",1721,1722))
triggerall = command = "QCB_x" || command = "QCB_y" || command = "QCB_z"
triggerall = statetype != A && numhelper(100) = 1 && numhelper(500) = 0 && var(14) = 1
trigger1 = ctrl
trigger2 = (stateno = [200,243]) || (stateno = [400,499])
trigger2 = movecontact && stateno != 229 && stateno != 244

[State -1, ]
type = ChangeState
value = ifelse(command = "QCB_x",2062,ifelse(command = "QCB_y",2063,2064))
triggerall = command = "QCB_x" || command = "QCB_y" || command = "QCB_z"
triggerall = statetype != A && numhelper(100) = 1 && numhelper(500) = 0 && var(14) = 6
trigger1 = ctrl
trigger2 = (stateno = [2530,2542]) && movecontact && stateno != 2541

;vOA^bN
[State -1]
type = ChangeState
value = 280
triggerall = (numhelper(200) = 0 && numhelper(100) = 0) || (numhelper(100) = 1)
triggerall = numhelper(500) = 0 && numhelper(1) = 0 && var(14) < 5
triggerall = command = "QCB_a" && power >= 1000 && statetype != A
trigger1 = ctrl
trigger2 = stateno != [700,3050)
trigger2 = hitdefattr = SC, NA
trigger2 = movecontact

[State -1]
type = ChangeState
value = 1436
triggerall = var(14) > 4
triggerall = numhelper(500) = 0 && numhelper(1) = 0
triggerall = command = "QCB_a" && power >= 1000 && statetype != A
trigger1 = ctrl
trigger2 = stateno = [2000,3050)
trigger2 = hitdefattr = SC, NA
trigger2 = movecontact

[State -1, ]
type = ChangeState
value = 1700 + (command = "rd_y") + 2*(command = "rd_z" && command != "rd_y")
triggerall = command = "rd_x" || command = "rd_y" || command = "rd_z" 
triggerall = statetype != A && numhelper(1) = 0 && numhelper(500) = 0 && numhelper(100) = 1 && var(14) = 1
trigger1 = ctrl
trigger2 = (stateno = [200,243]) || (stateno = [400,499])
trigger2 = movecontact && stateno != 229 && stateno != 244
trigger3 = (stateno = [150,153]) && numhelper(100) = 0

[State -1, ]
type = ChangeState
value = 2047 + (command = "rd_y") + 2*(command = "rd_z" && command != "rd_y")
triggerall = command = "rd_x" || command = "rd_y" || command = "rd_z" 
triggerall = statetype != A && numhelper(1) = 0 && numhelper(500) = 0 && numhelper(100) = 1 && var(14) = 6
trigger1 = ctrl
trigger2 = (stateno = [2530,2542]) && movecontact && stateno != 2541

[State -1, ]
type = ChangeState
value = 1730+6*(command = "ss_z")
triggerall = command = "ss_x" || command = "ss_y" || command = "ss_z"
triggerall = statetype != A && numhelper(100) = 1 && var(14) = 1
trigger1 = ctrl
trigger2 = (stateno = [200,243]) || (stateno = [400,499])
trigger2 = movecontact && stateno != 229 && stateno != 244
trigger3 = stateno = 40 && movetype != H

[State -1, ]
type = ChangeState
value = 2051+4*(command = "ss_z")
triggerall = command = "ss_x" || command = "ss_y" || command = "ss_z"
triggerall = statetype != A && numhelper(100) = 1 && var(14) = 6
trigger1 = ctrl
trigger2 = (stateno = [2530,2542]) && movecontact && stateno != 2541
trigger3 = stateno = 40 && movetype != H

[State -1]
type = ChangeState
value = 194
triggerall = numhelper(111) = 0 && var(14) < 2
triggerall = command = "QCB_c" && power >= 1000
trigger1 = statetype != A && ctrl

;===========================================================================
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = command = "FF" && ctrl
trigger1 = statetype = S && ((var(14) = 0 && numhelper(100) = 0) || (var(14) != 0 && numhelper(100) = 1))
trigger2 = statetype = A && numhelper(100) = 1 && (var(14) = 0 || var(14) = 5)

[State -1, Run Fwd]
type = ChangeState
value = 108
triggerall = command = "FF" && ctrl
trigger1 = statetype = S && var(14) = 0 && numhelper(100) = 1

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = command = "BB" && ctrl
trigger1 = statetype = S && ((var(14) = 0 && numhelper(100) = 0) || (var(14) != 0 && numhelper(100) = 1))
trigger2 = statetype = A && numhelper(100) = 1 && (var(14) = 0 || var(14) = 5)

[State -1, Run Back]
type = ChangeState
value = 109
triggerall = command = "BB" && ctrl
trigger1 = statetype = S && var(14) = 0 && numhelper(100) = 1

;Wv
[State -1]
type = varset
trigger1 = command = "holddown"
trigger1 = time > 5
trigger1 = statetype != A && ctrl
var(4) = 1

[State -1]
type = varset
trigger1 = command = "DU"
trigger1 = statetype = S && ctrl
var(3) = 1

[State -1]
type = ChangeState
trigger1 = command = "DU"
trigger1 = statetype != A && ctrl
value = 40

[State -1]
type = HitOverride
trigger1 = (var(14) = [5,6]) && (stateno != [130,155])
time = 1
attr = SCA, AA, AP, AT
slot = 0
stateno = 5000

[State -1]
type = ChangeAnim
trigger1 = var(14) = 5 && anim = [5,6]
value = 1228

[State -1]
type = ChangeAnim
trigger1 = var(14) = 6 && anim = [5,6]
value = 1462

[State -1]
type = ChangeState
value = 751
triggerall = var(14) > 4 && stateno != 751
trigger1 = var(12) <= 0
trigger2 = parent,var(33) = 2
trigger3 = parent,stateno = 4000

[State -1]
type = VarSet
trigger1 = roundstate = 2
fvar(1) = 0.05*(10-ceil(10*enemy,life/enemy,const(data.life)))

[State -1]
type = VarSet
trigger1 = roundstate = 2
fvar(2) = 0.05*(10-ceil(10*life/1000))

[State -1]
type = VarSet
trigger1 = var(14) > 4
fvar(3) = parent,fvar(3)

[State -1]
type = VarSet
trigger1 = roundstate = 2
fvar(0) = fvar(3)*(1.0-fvar(1)+fvar(2)-ifelse((var(23) = [1,22]),0.08*ceil(var(23)/2),ifelse(var(23) > 22,0.9,0)))

[state -1]
type = VarSet
trigger1 = stateno != 0 && stateno != 195 && stateno != 200 && (stateno != [210,215]) && (stateno != [800,900])
trigger1 = (stateno != [1000,1200]) && (stateno != [1400,1450]) && (stateno != [1600,3300])
;trigger2 = numhelper(100) = 1 && var(14) = 2
var(15) = 0

[State -1]
type = VarSet
triggerall = RoundState = 2
trigger1 = enemy,movetype != H
var(23) = 0
ignorehitpause = 1

[State -3x]
type = VarAdd
triggerall = RoundState = 2
trigger1 = movehit = 1
var(23) = 1

[State -1]
type = VarSet
trigger1 = !alive
var(33) = 2

[State -1]
type = VarSet
trigger1 = (var(14) = [5,6]) && var(34) != 9 && movetype = H
var(34) = 9

[State -1]
type = VarSet
trigger1 = (var(14) = [5,6]) && var(34) != 0 && movetype != H
var(34) = 0

[State -1]
type = VarSet
trigger1 = command = "xx" && var(25) = 0 && power >= 1000
trigger1 = (var(14) = 0 && numhelper(100) = 1) || var(14) = 5
var(25) = 1

[State -1]
type = VarSet
trigger1 = command = "holdf" && var(25) = 1 && power >= 1000
trigger1 = (var(14) = 0 && numhelper(100) = 1) || var(14) = 5
var(25) = 2

[State -1]
type = VarSet
trigger1 = command = "y" && var(25) = 2 && power >= 1000
trigger1 = (var(14) = 0 && numhelper(100) = 1) || var(14) = 5
var(25) = 3

[State -1]
type = VarSet
trigger1 = command = "z" && var(25) = 3 && power >= 1000
trigger1 = (var(14) = 0 && numhelper(100) = 1) || var(14) = 5
var(25) = 4

[State -1]
type = VarSet
trigger1 = time > 25 && var(25) = 1
trigger2 = time > 10 && var(25) = 2
trigger3 = time > 10 && var(25) = 3
trigger4 = (stateno = 3300 || stateno = 2520) && var(25) = 4
var(25) = 0

[State -1]
type = NotHitBy
trigger1 = var(14) = [5,6]
value = , AT

[State -1]
type = ParentVarSet
trigger1 = var(14) = [5,6]
trigger1 = abs(parentdist X) < 45 && parent,var(30) != 2
var(30) = 2

[State -1]
type = ParentVarSet
triggerall = var(14) = [5,6]
triggerall = parent,var(30) != 0
trigger1 = parentdist X < -45
trigger2 = vel x > 0
var(30) = 0

[State -1]
type = ParentVarAdd
trigger1 = (var(14) = [5,6]) &&  stateno = [150,153]
trigger1 = time%2 = 0 &&  parent,var(12) = [0,1000]
var(12) = -2

[State -1]
type = ScreenBound
trigger1 = var(14) = [5,6]
value = 1
movecamera = 0,0

[State -1]
type = ParentVarSet
trigger1 = var(14) = [5,6]
fvar(11) = parentdist X

[State -1]
type = PlayerPush
trigger1 = var(14) = [5,6]
trigger1 = stateno != [1434,1435]
value = 1

[State -1]
type = turn
trigger1 = var(14) = [5,6]
trigger1 = p2dist X < 0 && (stateno != [2052, 3000]) && stateno != 1750 && stateno != [100,102]
;[2052, 2055]

[State -1]
type = ChangeState
triggerall = var(14) = [5,6]
trigger1 = stateno != 1434 && ctrl
trigger1 = command = "a" && command != "x" && command != "y" && command != "z"
value = 1434

[State -1]
type = VarSet
var(8) = 100
triggerall = numhelper(500) = 1 && command = "a"
trigger1 = (helper(500),stateno = [2224,2225])
trigger2 = (helper(500),stateno = [3331,3390]); && hitdefattr = SC, NA

;====================================
;CVQ
[State -1]
type = ChangeState
value = 1460
triggerall = numhelper(100) = 0 && numhelper(10) = 0
triggerall = numhelper(2) = 0 && numhelper(5) = 0
triggerall = numhelper(1) = 0 && numhelper(500) = 0
triggerall = statetype != A && ctrl
trigger1 = command = "bx" || command = "by" || command = "bz"
trigger2 = command = "b"

[State -1]
type = ChangeState
value = 1470
triggerall = numhelper(100) = 0 && numhelper(10) = 0
triggerall = numhelper(2) = 0 && numhelper(5) = 0
triggerall = numhelper(1) = 0 && numhelper(500) = 0
triggerall = statetype = A && ctrl
trigger1 = command = "b"

;SQ
[State -1]
type = ChangeState
value = 1400
triggerall = numhelper(100) = 0 && numhelper(10) = 0
triggerall = numhelper(2) = 0 && numhelper(5) = 0
triggerall = numhelper(1) = 0 && numhelper(500) = 0
triggerall = statetype != A && ctrl
trigger1 = command = "ax" || command = "ay" || command = "az"
trigger2 = command = "a"

[State -1]
type = ChangeState
value = 1410
triggerall = numhelper(100) = 0 && numhelper(10) = 0
triggerall = numhelper(2) = 0 && numhelper(5) = 0
triggerall = numhelper(1) = 0 && numhelper(500) = 0
triggerall = statetype = A && ctrl
trigger1 = command = "a"

;vanish
[State -1]
type = changestate
triggerall = numhelper(100) = 1
triggerall = Movetype != A && statetype != A && ctrl
trigger1 = command = "a" && command != "x" && command != "y" && command != "z" && var(14) = 0
trigger2 = command = "b" && command != "x" && command != "y" && command != "z" && var(14) = 1
value = 1450

;-------------------------
[State -1]
type = ChangeState
value = 5910
trigger1 = var(0) = 10 && command = "holds" && command = "holdc"

;advancing guard
[State -1]
type = ChangeState
value = 1180
trigger1 = command = "xyz"
trigger1 = stateno = [150,153]

;]j
[State -1]
type = ChangeState
value = 700
triggerall = numhelper(100) = 0
triggerall = statetype != A
triggerall = command = "xyz"; || command = "c"
trigger1 = ctrl

[State -1]
type = varset
triggerall = var(0) = 1
trigger1 = command = "x" || command = "y" || command = "z"
var(2) = 1

[State -1]
type = VarSet
trigger1 = stateno != 100
trigger1 = stateno != [10,11]
trigger1 = var(0) != 10
var(0) = 0

;---------------------------------------------------------------------------
;Sliding Kick

[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "sla" && (stateno != [100,106]) && numhelper(100) = 0
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Normal Throw
;
[State -1, Throw]
type = ChangeState
value = 800 -590*(numhelper(500) = 1 && p2bodydist X > 30)-585*(numhelper(500) = 1 && p2bodydist X <= 30)
triggerall = command = "z" && statetype = S && ctrl
triggerall = stateno != 100 && numhelper(1) = 0
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 30
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H

[State -1, Throw]
type = ChangeState
value = 801 -591*(numhelper(500) = 1 && p2bodydist X > 30)-585*(numhelper(500) = 1 && p2bodydist X <= 30)
triggerall = command = "z" && statetype = S && ctrl
triggerall = stateno != 100 && numhelper(1) = 0
trigger1 = command = "holdback"
trigger1 = p2bodydist X < 30
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H

;===========m[}A^bN========================

;Stand Light Attack
;
[State -1, Stand Light Attack]
type = ChangeState
value = 200
triggerall = command = "x" && numhelper(100) = 0
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Attack]
type = ChangeState
value = 207
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 0
triggerall = command = "holdf" || var(2) = 1
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Attack]
type = ChangeState
value = 205
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 0 && var(2) = 0
triggerall = command != "holddown" && command != "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Attack]
type = ChangeState
value = 2507
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 5
triggerall = command = "holdf";|| var(2) = 1
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Attack]
type = ChangeState
value = 2501
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 5
triggerall = command != "holddown" && command != "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Attack]
type = ChangeState
value = 206
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 1
triggerall = command != "holddown" && p2bodydist X > 30
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Attack]
type = ChangeState
value = 2531
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 6
triggerall = command != "holddown" && p2bodydist X > 30
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Attack]
type = ChangeState
value = 208
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 1
triggerall = command != "holddown" && (p2bodydist X <= 30 || var(2) = 1)
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Attack]
type = ChangeState
value = 2530
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 6
triggerall = command != "holddown" && (p2bodydist X <= 30 || var(2) = 1)
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;Stand Middle Attack
;
[State -1, Stand Middle Attack]
type = ChangeState
value = 210
triggerall = command = "y" && p2bodydist X > 30 && numhelper(100) = 0
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5

[State -1, Stand Middle Attack]
type = ChangeState
value = 215
triggerall = command = "y" && p2bodydist X <= 30 && numhelper(100) = 0
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5

[State -1, Stand Middle Attack]
type = ChangeState
value = 227
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 1
triggerall = command = "holdba"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 2537
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 6
triggerall = command = "holdba"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 228
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 1
triggerall = command = "holdf" && stateno != 100
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 2538
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 6
triggerall = command = "holdf" && stateno != 100
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 230
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 0 && var(2) = 0
triggerall = command = "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 225
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 0
triggerall = command != "holddown" && command != "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 2509
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 5
triggerall = command = "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 2502
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 5
triggerall = command != "holddown" && command != "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 226
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 1
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Middle Attack]
type = ChangeState
value = 2532
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 6
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Stand Strong Attack
;
[State -1, Stand Strong Attack]
type = ChangeState
value = 220-10*((numhelper(1) = 1 || numhelper(500) = 1) && p2bodydist X > 30)-5*((numhelper(1) = 1 || numhelper(500) = 1) && p2bodydist X <= 30)
triggerall = command = "z" && numhelper(100) = 0
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 245
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 0
triggerall = command = "holdba"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 243
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 1
triggerall = var(2) = 1
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 2540
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 6
triggerall = var(2) = 1
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 242
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 1
triggerall = command = "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 2539
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 6
triggerall = command = "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 240
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 0
triggerall = command != "holddown" && command != "holdba"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 2508
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 5
triggerall = command = "holdba"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 2503
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 5
triggerall = command != "holddown" && command != "holdba"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 241
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 1
triggerall = command != "holddown" && command != "holdf"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Strong Attack]
type = ChangeState
value = 2533
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 6
triggerall = command != "holddown" && command != "holdf"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 3610
triggerall = command = "upper_s"
triggerall = power >= 1000
triggerall = statetype != A && numhelper(500) = 0 && numhelper(100) = 0 && numhelper(1) = 0 && numhelper(3) = 0
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [700,3100)
trigger2 = movecontact

[State -1, Taunt]
type = ChangeState
value = 3800
triggerall = command = "QCB_s"
triggerall = power >= 1000
triggerall = statetype != A && numhelper(500) = 0 && numhelper(100) = 0 && numhelper(1) = 0 && numhelper(3) = 0
trigger1 = ctrl

[State -1, Taunt]
type = ChangeState
value = 3611;3850
triggerall = command = "QCF_s"
triggerall = power >= 1000 && (PalNo = 2 || PalNo = 5)
triggerall = statetype != A && numhelper(500) = 0 && numhelper(100) = 0 && numhelper(1) = 0 && numhelper(3) = 0
trigger1 = ctrl

[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start" && var(14) < 5
trigger1 = statetype != A && ctrl

[State -1, Taunt]
type = VarSet
var(24) = 195
triggerall = command = "start" && var(14) > 4
trigger1 = statetype != A && ctrl && var(24) != 195

[State -1, Taunt]
type = VarSet
var(24) = 0
triggerall = var(14) > 4 && var(24) = 195
trigger1 = parent,stateno = 1449
;---------------------------------------------------------------------------
;Crouching Light Attack
;Ⴊݎ
[State -1, Crouching Light Attack]
type = ChangeState
value = 400
triggerall = command = "x" && numhelper(100) = 0
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Light Attack]
type = ChangeState
value = 405
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 0
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Light Attack]
type = ChangeState
value = 2504
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 5
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Light Attack]
type = ChangeState
value = 406
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 1
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Light Attack]
type = ChangeState
value = 2534
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 6
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
;Crouching Middle Attack
;Ⴊݒ
[State -1, Crouching Middle Attack]
type = ChangeState
value = 410
triggerall = (command = "y" || ((stateno = [100,106]) && command = "sla")) && numhelper(100) = 0
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Middle Attack]
type = ChangeState
value = 415
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 0
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Middle Attack]
type = ChangeState
value = 2505
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 5
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Middle Attack]
type = ChangeState
value = 416
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 1
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Middle Attack]
type = ChangeState
value = 2535
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 6
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
;Crouching Strong Attack
;Ⴊ݋
[State -1, Crouching Strong Attack]
type = ChangeState
value = 420
triggerall = command = "z" && numhelper(100) = 0
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Strong Attack]
type = ChangeState
value = 425
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 0
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Strong Attack]
type = ChangeState
value = 2506
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 5
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Strong Attack]
type = ChangeState
value = 426
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 1
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1, Crouching Strong Attack]
type = ChangeState
value = 2536
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 6
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
;Jump Light Attack
;󒆎

[State -1, Jump Light Attack]
type = ChangeState
value = 635
triggerall = (command = "x" || command = "y" || command = "z") && numhelper(100) = 1 && var(14) = 0
triggerall = command = "holdf"
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Light Attack]
type = ChangeState
value = 2510
triggerall = (command = "x" || command = "y" || command = "z") && numhelper(100) = 1 && var(14) = 5
triggerall = command = "holdf"
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Light Kick]
type = ChangeState
value = 640
triggerall = (command = "x" || command = "y" || command = "z") && numhelper(100) = 1 && var(14) = 0
triggerall = command = "holddf"
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Light Kick]
type = ChangeState
value = 2514
triggerall = (command = "x" || command = "y" || command = "z") && numhelper(100) = 1 && var(14) = 5
triggerall = command = "holddf"
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Light Attack]
type = ChangeState
value = 600
triggerall = command = "x" && numhelper(100) = 0
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Light Attack]
type = ChangeState
value = 605
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 0
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Light Attack]
type = ChangeState
value = 2511
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 5
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Light Attack]
type = ChangeState
value = 606
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 1
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Light Attack]
type = ChangeState
value = 2544
triggerall = command = "x" && numhelper(100) = 1 && var(14) = 6
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
;Jump Middle Attack
[State -1, Jump Middle Attack]
type = ChangeState
value = 610
triggerall = command = "y" && numhelper(100) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = movecontact

[State -1, Jump Middle Attack]
type = ChangeState
value = 615
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 605
trigger2 = movecontact

[State -1, Jump Middle Attack]
type = ChangeState
value = 2512
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 5
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 2511
trigger2 = movecontact

[State -1, Jump Middle Attack]
type = ChangeState
value = 616
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 1
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 605
trigger2 = movecontact

[State -1, Jump Middle Attack]
type = ChangeState
value = 2545
triggerall = command = "y" && numhelper(100) = 1 && var(14) = 6
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 2544
trigger2 = movecontact
;---------------------------------------------------------------------------
;Jump Strong Attack
[State -1, Jump Strong Attack]
type = ChangeState
value = 620
triggerall = command = "z" && numhelper(100) = 0
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Strong Attack]
type = ChangeState
value = 630
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 0
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Strong Attack]
type = ChangeState
value = 2513
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 5
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Strong Attack]
type = ChangeState
value = 631
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 1
trigger1 = statetype = A
trigger1 = ctrl

[State -1, Jump Strong Attack]
type = ChangeState
value = 2546
triggerall = command = "z" && numhelper(100) = 1 && var(14) = 6
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
